//ķ
//                                                                    
//  Program module: Route.cpp                                         
//  Description   : Make routing scheme for FIDONET hub               
//                                                                    
//͸(C)Copyright 1994-2003'Software for You'Programmers Group ͹
// CiB   Written by Yuri V. Safronov                              SfY 
//ͼ

#define DEBUG_BREAK getchar()

#if defined (__TSC__)
  #pragma call(inline_max => 150)
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#if defined (__TSC__)
  #include <alloc.h>
  #include <dir.h>
  #define EOLCHR "\n"
#elif defined (__WATCOMC__)
  #include <malloc.h>
  #include <direct.h>
  #include <io.h>

  #define fnsplit _splitpath
  #define fnmerge _makepath

  #define EOLCHR "\n"

  #if defined (__OS2__)
    #define _OS2 1
  #endif
#elif defined(__GNUC__)
//  #include <malloc.h>
  #include <dirent.h>
  #include <unistd.h>
  #include <glob.h>

  #define strnicmp(x,y,z) strncasecmp(x,y,z)
  #define stricmp(x,y) strcasecmp(x,y)
  #define itoa(i,a,base) (sprintf(a,"%i",i),a)

  #define EOLCHR "\n"
  #define link linkd
#endif

//
//  History:
//   1.10.94 - public alpha
//   5.10.94 - make possible blank lines & comments in raw-files
//           - do kill myself in route scheme
//           - add address of mine as the first command argument
//             and routing type as second one
//           - change version to 1.01b
//   6.10.94 - add itrack and t-mail support
//           - change version to 1.02b
//   7.10.94 - fix default address shotening for t-mail
//           - add flags FullAddr etc. for clean logic
//           - turn off kill myself in route scheme
//           - add unrouted section
//           - change version to 1.03b
//  10.10.94 - add 'Send' statements to Squish
//           - change version to 1.04b
//  11.10.94 - add direct statements to T-mail
//           - add 'via' routing in Route.raw
//             kill myself if '>' placed at the very beginning
//             of route branch (Basil's Dolmatov idea)
//           - add flavors to Itrack
//           - change version to 1.05b
//  13.10.94 - add slashs in short address for t-mail
//             (thanx to Alex Korchmar)
//           - rewrote putting direct section to squeeze it
//           - rewrote direct section logic for t-mail
//             (thanx to Alex Korchmar)
//           - set firstly lost 'pm_compat' flag
//             into os/2 version header(thanx to Alex Korchmar)
//           - change version to 1.06b
//  14.10.94 - add bpack support
//           - change version to 1.07b
//  26.10.94 - fix stupid bug with 'noarc' in squish's 'Send'
//             (Slava Abramov)
//           - rewrote flavor flag implementation to bitmask
//           - change version to 1.08b
//  01.11.94 - rewrote 'Direct' generation for t-mail mode
//             now 'H' means Hold, for Direct and Hold use
//             'DH' in Links.raw (Alex Korchmar)
//           - kill point autorouting string (route your points
//             with your favorite flavors handly)
//           - change version to 1.09b
//  06.11.94 - major changes to make router more handy:
//             config parser, working with destination config
//             file, using several raw routing files etc.
//           - change version to 1.10b
//  09.11.94 - add Hubroute gen. section (stuff such as mkraw did)
//           - minor changes in memory allocation
//           - fix stupid bug if PutUnrouted(crash if more then one
//             line in this section
//           - enlarge buffer size up to 32k for nodelist scanning
//           - change version to 1.11b
//  10.11.94 - add creation time to autorouting header
//           - add progress indicator to nodelist scanner
//           - change version to 1.12b
//  11.11.94 - speed-up routing writing by pre-growing route tree
//             up to 1 level.
//           - add routing minimization and 'Minimize' keyword
//           - change version to 1.13b
//  27.12.94 - add 'routed via us but missing in links' diagnostics,
//             such nodes sets to Hold flavor (Basil Dolmatov).
//           - change version to 1.14b
//  15.03.95 - fix minor bug in PutDirect section w/multizone
//             routing
//           - change version to 1.15b
//  17.04.95 - add imbink support
//           - change version to 1.16b
//  15.06.95 - add Xmail support
//           - change version to 1.17b
//  30.06.95 - fix minor bug in t-mail routing section (change 'file'
//             to 'files')
//           - change version to 1.18b
//  03.07.95 - add ifmail(sendmail) support
//           - change version to 1.19b
//  10.08.95 - change procedures for treating 'all in my net to hold'
//             situation (except ifmail mode. I don't know how to
//             write 'send hold 5020/*' for ex.
//           - change version to 1.20b
//  02.09.95 - fix bug with 'route via itself' causes loop in optimization
//             procedure(reported by 5070/25)
//           - by mistake to v1.20 was placed intermediate version with
//             a lot of bugs in ifmail section. Now it's OK.
//           - add sendmail example (thanx 5020/182)
//           - change version to 1.21b
//  17.10.95 - add AKA support. Up to 50 node AKAs can be defined
//           - add 'DefaultFlavor' keyword. It's for nodes placed under
//             us but missing in 'Links'(idea by 5070/25).
//           - port to WC 10.0
//           - add 'DefaultRoute' keyword
//           - fix minor bug in t-mail section
//           - change version to 1.22b
//  01.11.95 - fix a lot of minor bugs (thanx to 5020/32)
//  19.11.95 - add BiP and Unimail support
//           - change version to 1.23b
//  24.11.95 - kill out nodename briefly (Unimail mode)
//           - change version to 1.24b
//  26.03.96 - ScanNode() now recognizes '*' as 'All'(for ex. in .rou)
//           - fix mistakes in information messages(thanks to /54)
//           - completely rewrote RouteMinimizing. Thanx to all beta
//             testers reported this bug and to Basil for a nice kludge
//             around n**3 algorithm.
//           - fix minor bug in tree-to-one-level procedure that can
//             cause unlimited loop with some incorrect rou files
//             (thanx to /54)
//           - add (encripted) sources to distributive
//           - change version to 1.25b
//  18.04.96 - Add 'Direct' directive for hold nodes in t-mail section
//             (thanx to /79)
//           - change version to 1.26b
//  23.08.97 - Fix bug with two hub akas (thanx to /79)
//           - Add support for t-mail 2601+
//           - change comment symbol in ifmail mode to '#'  
//           - add trust-file support
//           - change version to 1.27b
//  31.10.97 - Fix bug in ifmail routing output (thanx to 5030/568)
//           - clean up for freeBSD and Linux (thanx to 5030/568)
//           - fix minor bug in memory allocation
//             for minimize procedure
//           - fix minor bug in rou-file processing
//           - change version to 1.28b
//  12.02.98 - Fix minor bug in ifmail routing output
//           - change version to 1.29b
//  23.05.98 - Add QECHO support (specs by 461/64)
//           - Add Fidogate support
//           - fix minor bug in Hubroute (thanx to 5020/1301)
//           - cleanup for GNUC optimization mode (thanx to 461/64)
//           - some minor changes to speedup for 32-bit.
//           - some changes in ifmail mode, now unrouted branches
//             will be ignored. Do not forget to place some
//             default routing to whole world!!!!
//           - change version to 1.30b
//  22.01.99 - Fixes in QECHO support (thanx to 461/64)
//           - Add Ftrack support (specs by 5020/79)
//           - change version to 1.31b
//  24.04.99 - a lot of bugfixes (reported by many testers)
//           - clean up readmes
//  30.06.00 - bugfix for last hub in region (10x to 2:469/142)
// 
//  06.02.02 - add KillTransit cfg line
//           - change version to 1.32b
// 
//
#define VERSION   "1.32beta"
#define DATE      "06-Feb-2002"
#define CREATED   "%c %s routing for %d:%d/%d. Created by Hubroute generator "VERSION""EOLCHR"%c %45s%c"EOLCHR""
#if defined(_OS2) || defined (__OS2__)
  #define TARGET "OS/2"
#elif defined (__NT__)
  #define TARGET "Win32"
#elif defined (__GNUC__)
  #define TARGET "GNU/Unix"
#else
  #define TARGET "DOS"
#endif

#ifdef boolean
  #undef boolean
#endif

typedef unsigned short ushort;
typedef unsigned long  ulong;
typedef unsigned short boolean;
#define local          static


struct nodeaddr
  {
    ushort z,n,f;
    nodeaddr(ushort zz=0, ushort nn=0, ushort ff=0) : z(zz), n(nn), f(ff){};
    boolean operator==(nodeaddr& a) {return z == a.z &&
                                       n == a.n &&
                                       f == a.f; }
    void CleanUp(void){z=n=f=0;}
  };

struct listitem
  {
    ushort      idx; // uplink index in file
    ushort      is_uplink; // is first in route.raw
    nodeaddr   addr;
  };

struct link
  {
    ushort  flavor;
    nodeaddr   addr;
  };

struct CfgValue
  {
    char *      Name;
    void *      Value;
    ushort      Pass;
    boolean        (*LoadVal)(char * in, void * out);
  };

//
//   Error messages
//
local const char * ErrNoMemory = EOLCHR"Cannot allocate memory.";
local const char * ErrOpenCfg = EOLCHR"Cannot open config file.";
local const char * ErrNoFile = "Cannot open file.";
local const char * ErrOpenTmp = EOLCHR"Cannot open temp file.";
local const char * ErrOpenDest = EOLCHR"Cannot open dest file.";
local const char * ErrUnknownRouteType = EOLCHR"Unsupported route type.";
local const char * ErrUnknownMinType = EOLCHR"Illegal value of \"Minimized\".";
local const char * ErrQuoteString = "Illegal quoted string.";
local const char * ErrMissMainAddr = EOLCHR"Missing or illegal main address.";
local const char * ErrMissRouteType = EOLCHR"Missing \"RouteType\" keyword.";
local const char * ErrMissMinType = EOLCHR"Missing \"Minimize\" keyword. YES Accepted.";
local const char * ErrNoReplEnd = EOLCHR"Missing \"RouteEnd\" in dest file.";
local const char * ErrNoReplBeg = EOLCHR"Missing \"RouteBegin\" in dest file.";
local const char * ErrBadNdlType = "Bad \"HubRoute\" definition.";
local const char * ErrMissDirect = EOLCHR"%s is routed via us, but missing in \"Link\" definitions."EOLCHR" \'DefaultFlavor\' assumed.";
local const char * ErrReroute = EOLCHR"Re-routing for %s.";
local const char * ErrLoop = EOLCHR"RouteLoop detected for %s. Try to route by default";
local const char * WarnNoMin = EOLCHR"Cannot minimize tree because of low memory";
#define Error(s)   fprintf(stderr,s)
//#define ErrorN(s,node)   fprintf(stderr,s,node.z,node.n,node.f)
#define ErrorS(s,str)   fprintf(stderr,s,str)
#define ErrorL(s)  fprintf(stderr, EOLCHR"%s %d: %s", CfgFile, CfgLine, s)

#define true     1
#define false    0

#define ItemNum(arr) (sizeof(arr)/sizeof(arr[0]))

#define MAXNODES 5000
#define MAXWILD 2000
#define MAXLINKS 1000
#define MAXAKAS  50
#define BUFFLEN  30000
#define PATHLEN  100
#define WILDVALUE 0xFFFF
#define KLINCH_DEPTH 10

int MAX_ROUTE_LEN=64;


enum
  {
    DIRECT_FLAVOR = 1,
    CRASH_FLAVOR = 2,
    HOLD_FLAVOR = 4,
    NORMAL_FLAVOR = 16,
    FILE_FLAVOR = 32,
    NOARC_FLAVOR = 64
  };

local ushort     DefaultFlavor = HOLD_FLAVOR;

#if defined (__WATCOMC__)
  #define MAXPATH 256
  #define MAXDRIVE  3
  #define MAXDIR  256
  #define MAXFILE NAME_MAX
  #define MAXEXT  NAME_MAX
#elif defined (__GNUC__)
  #define MAXPATH 512
  #define MAXDIR  512
  #define MAXFILE 512
  #define MAXEXT  512
#endif

#if defined(__GNUC__)
 local char TempFile[MAXPATH];
#else
 local char TempFile[MAXPATH];
 local char OutDrv[MAXDRIVE];
#endif

local char OutDir[MAXDIR];
local char OutName[MAXFILE];
local char OutExt[MAXEXT];

#define    SQUISH       1
#define    ITRACK       2
#define    TMAIL        3
#define    BPACK        4
#define    IMBINK       5
#define    XMAIL        6
#define    IFMAIL       7
#define    BIP          8
#define    UNIMAIL      9
#define    QECHO        10
#define    FIDOGATE     11
#define    FTRACK       12

local ushort     RouteMode = 0;

local ushort     MinMode = 0;
local ushort     KillTransit = 0;

#if defined (__GNUC__)
 glob_t globbuf;
#endif
local char *     Buff;
local char *     Prefix;
local nodeaddr   PrevNode; 
local nodeaddr  *MyNode=NULL;
local nodeaddr   UpNode(0,0,0); // t-mail routing only
local link     * Link;
local listitem * Node;
local listitem * WildNode; // Wildcards in nodelist
local ushort     nNodes=0, nLinks=0, nAKAs=0, nWilds=0;
local ushort     level; // 0 - node, 1 - net, 2 - zone, 3 - world
local time_t     currtime;

local char *     CfgFile;
local ushort     CfgLine;

local char       WriteTo[PATHLEN];
local FILE *     NewRoute;
local FILE *     OldRoute;
#define    Spit(s)   { fputs(s, NewRoute); fputs(EOLCHR, NewRoute); }

local char       LogFile[PATHLEN];;
local char       RouteBegin[100];
local char       RouteEnd[100];

local boolean       StarWild, AddPoint, DefaultFromMe,
                 FullAddr, FillRoute, WithSlash, TmailAddFor;
local char      CmntSym = ';';

local ushort
InMemory(nodeaddr addr)
  {
    for (ushort i = 0; i < nNodes; i++)
        if (Node[i].addr == addr)
            return i;
    return 0xFFFF;
  }

local boolean
IsMyNode(nodeaddr addr)
  {
    int i;
    for (i = 0; i < nAKAs; i++)
        if (MyNode[i] == addr)
            return true;
    return false;
  }

local boolean
DirectLink(ushort Idx)
  {
    int i;
    for (i = 0; i < nLinks; i++)
        if (Link[i].addr == Node[Idx].addr)
            return true;
    return false;
  }

local boolean
DirectLink(nodeaddr n)
  {
    int i;
    for (i = 0; i < nLinks; i++)
        if (Link[i].addr == n)
            return true;
    return false;
  }


inline void
skipws(char **p)
  {
    while (**p == ' ' || **p == '\t' || **p == '\r')
      (*p)++;
  }

local ushort
getnum(char **p)
  {
    int i = 0;
    while (isdigit(**p))
        i = i*10 + (*((*p)++) - '0');
    return (ushort)i;
  }

local nodeaddr
ScanNode(char **p)
  {
    nodeaddr addr = PrevNode;
    ushort   tmp, mode;

#define START 1
#define SCAN  2
#define DONE  3

    skipws(p);
    mode = START;
    while (mode != DONE)
      {
        switch (mode)
          {
            case START:
                if (strnicmp(*p, "World", 5) == 0)
                  {
                    addr.z = addr.n = addr.f = WILDVALUE;
                    PrevNode = *MyNode; // _Main_ aka
                    *p += 5;
                    return addr;
                  }
            case SCAN:
                skipws(p);
                if (strnicmp(*p, "All", 3) == 0)
                  {
                    tmp = WILDVALUE;
                    *p += 3;
                  }
                else if (**p == '*')
                  {
                    tmp = WILDVALUE;
                    *p += 1;
                  }
                else
                    tmp = getnum(p);
                switch (**p)
                  {
                    case ':':
                        addr.z = tmp;
                        mode = SCAN;
                        (*p)++;
                        break;
                    case '/':
                        addr.n = tmp;
                        mode = SCAN;
                        (*p)++;
                        break;
                    default:
                        addr.f = tmp;
                        mode = DONE;
                  }
            }
      }
    PrevNode = addr;
    // Skip unnesessary tail such as point address etc.
    while (**p != ' ' && **p != '\t' && **p != '\r' && **p != '\n' && **p != '\0')
      (*p)++;
    return addr;
#undef START
#undef SCAN
#undef DONE
  }

local ushort
WriteNode(nodeaddr Node, char * out, short addrtype)
  {
    char tmp[10];

    ushort wildlevel = 0;
    if (Node.f == WILDVALUE)
        wildlevel++;
    if (Node.n == WILDVALUE)
        wildlevel++;
    if (Node.z == WILDVALUE)
        wildlevel++;
    if ( wildlevel == level || addrtype == 1)
      {
        const char * Wild = (StarWild) ? "*" : "All";
        strcat(out, " ");

        if (Node.z == WILDVALUE && Node.n == WILDVALUE
                                && Node.n == WILDVALUE)
            strcat(out, StarWild ? "*:*/*" : "World");
        else
          {
            if (addrtype || FullAddr || Node.z != PrevNode.z)
              {
                strcat(out, itoa(Node.z,tmp,10));
                strcat(out, ":");
              }
            if (addrtype || FullAddr || Node.n != PrevNode.n
                                              || Node.f == WILDVALUE)
              {
                strcat(out, Node.n != WILDVALUE ? itoa(Node.n,tmp,10) : Wild);
                if (!WithSlash)
                    strcat(out, "/");
              }
            if (WithSlash)
                strcat(out, "/");
            strcat(out, Node.f != WILDVALUE ? itoa(Node.f,tmp,10) : Wild);
          }
        if (AddPoint && !addrtype)
            strcat(out, ".*");
        if (DefaultFromMe)
            PrevNode = *MyNode; // Main aka
        else
            PrevNode = Node;
      }
    return (ushort)strlen(out);
  }

local char *
StrNode(nodeaddr Node)
  {
    static char buff[40];
    boolean tmp = FullAddr;

    buff[0] = '\0';
    FullAddr = true;
    buff[WriteNode(Node, buff, 1)] = '\0';
    FullAddr = tmp;
    return buff;
  }

local ushort
TestCmpQuality(nodeaddr& S, nodeaddr& D)
  {
    ushort   Q = 0;

    if ( (D.z != WILDVALUE && S.z != D.z) ||
         (D.n != WILDVALUE && S.n != D.n) ||
         (D.f != WILDVALUE && S.f != D.f) )
        return 0;  // Not match

    if (D.z == WILDVALUE)
        Q++;
    else
        Q += 2;
    if (D.n == WILDVALUE)
        Q += 10;
    else
        Q += 20;
    if (D.f == WILDVALUE)
        Q += 100;
    else
        Q += 200; // Who cares... :)

    return Q;
  }

local void
FixWildcard(void)
  {
    ushort i;
    for (i = 0; i < nNodes; i++)
      {
      // Fix wildcard such as All:5020/All to All:All/All etc.
        if (Node[i].addr.z == WILDVALUE)
            Node[i].addr.n = WILDVALUE;
        if (Node[i].addr.n == WILDVALUE)
            Node[i].addr.f = WILDVALUE;

        ushort MaxQuality, MaxQualityIdx, cmp;
        MaxQuality = 0;
      // Try to route unrouted items to nearest wildcard
        if (Node[i].idx == WILDVALUE && !DirectLink(i)) // not routed
          {
	    ushort j;
            for (j = 0; j < nNodes; j++)
                if (Node[j].idx != WILDVALUE) // is routed
                    if ((cmp = TestCmpQuality(Node[i].addr, Node[j].addr)) > MaxQuality)
                      {
                        MaxQuality = cmp;
                        MaxQualityIdx = j;
                      }

            if (MaxQuality > 0)  // found correct match
              {
                boolean Klinch = false;
                ushort idx = MaxQualityIdx;
             // Try to recognize route-loop such as 2:5020/50 <= 2:5020/All
                for (j = 0; j < KLINCH_DEPTH && !Klinch; j++)
                    if (i == idx)     // We catch the same node
                        Klinch = true;
                    else if (idx != WILDVALUE)  // Catch unrouted
                        idx = Node[idx].idx;
                    else  // idx == WILDVALUE - unrouted (may be direct)
                        break;
                if (!Klinch)
                    Node[i].idx = MaxQualityIdx;
              }
          }
      }
  // Fixup my downlinks if they are undefined as Direct links
     for (i = 0; i < nNodes; i++) // Look for my downlinks
       {
         if (Node[i].idx != WILDVALUE && IsMyNode(Node[Node[i].idx].addr) && !DirectLink(i))
           {
             Link[nLinks].addr = Node[i].addr;
             Link[nLinks].flavor = DefaultFlavor;
             nLinks++;
             ErrorS(ErrMissDirect, StrNode(Node[i].addr));
           }
       }

  // Make the tree one-leveled
    for (i = 0; i < nNodes; i++)
      {
        if (Node[i].idx != WILDVALUE) // routed
          {
            nodeaddr Orig = Node[i].addr;
            while (!(Node[Node[i].idx].idx == WILDVALUE ||
                                     (DirectLink(Node[i].idx) &&
                                        Node[Node[i].idx].addr.f != 0xFFFF)))
            {
              Node[i].idx = Node[Node[i].idx].idx;
              if (Node[Node[i].idx].addr == Orig) // Loop detected
              {
                ErrorS(ErrLoop, StrNode(Node[Node[i].idx].addr));
                Node[Node[i].idx].idx = WILDVALUE;
                break;
              }
            }
          }
      }
  }

local boolean
IsWild(nodeaddr n)
{
  if ( n.z == WILDVALUE || n.n == WILDVALUE || n.f == WILDVALUE)
    return true;
  else
    return false;
}

int
CmpWild(void const * l1, void const * l2)
{
  if (((listitem*)l1)->addr.z > ((listitem*)l2)->addr.z)
    return 1;
  else if (((listitem*)l1)->addr.z < ((listitem*)l2)->addr.z)
    return -1;
  else if (((listitem*)l1)->addr.n > ((listitem*)l2)->addr.n)
    return 1;
  else if (((listitem*)l1)->addr.n < ((listitem*)l2)->addr.n)
    return -1;
  else if (((listitem*)l1)->addr.f > ((listitem*)l2)->addr.f)
    return 1;
  else if (((listitem*)l1)->addr.f < ((listitem*)l2)->addr.f)
    return -1;
  else
    return 0;
}

local void
RemoveUnnecessary(void)
  {
    ushort i, j;
  // Remove double-routed nodes if it's up-wild routed by the same way
    if (MinMode)
    {
      WildNode = (listitem*)calloc(MAXWILD, sizeof(listitem));
      if (WildNode != NULL)
      {
        for (i = 0; i < nNodes; i++)
          if (IsWild(Node[i].addr))
            WildNode[nWilds++] = Node[i];
        qsort(WildNode, nWilds, sizeof(listitem), CmpWild);

        for (i = 0; i < nNodes; i++)
          {
            if (Node[i].idx != WILDVALUE) // routed
              {
                for (j = 0; j < nWilds; j++)
                  {
                    if (!(Node[i].addr==WildNode[j].addr) &&
                        TestCmpQuality(Node[i].addr,WildNode[j].addr) > 0)
                    {
                      if (Node[i].idx == WildNode[j].idx && !DirectLink(i))
                        Node[i].idx = 0xFFFE;
                      break;
                    }
                  }
              }
          }
        free(WildNode);
      } 
      else
        Error(WarnNoMin);
    }
}

local char *
GetFlavor(link * pLink, char * Flav[])
  {
    if (pLink->flavor & CRASH_FLAVOR)
        return Flav[0];
    else if (pLink->flavor & DIRECT_FLAVOR)
        return Flav[1];
    else if (pLink->flavor & HOLD_FLAVOR)
        return Flav[2];
    else
        return Flav[3];
  }

char * SqFlavors[] =
  {
    "Crash ", "Direct", "Hold  ", "Normal"
  };
local void
MakeSqPrefix(link * pLink, char * out)
  {
    strcpy(out, "Route ");

    strcat(out, GetFlavor(pLink, SqFlavors));

    if (pLink->flavor & FILE_FLAVOR)
        strcat(out, " file");
    else
        strcat(out, "     ");

    if (pLink->flavor & NOARC_FLAVOR)
        strcat(out, " NoArc");
    else
        strcat(out, "      ");

     WriteNode(pLink->addr, out, 1);
     strcat(out, " ");
  }

local void
PutDirects(ushort mask, ushort pattern, const char * Pfix)
  {
    int i;
    PrevNode = *MyNode; // Main aka
    strcpy(Buff, Pfix);
    strcpy(Prefix, Pfix);
    for (i = 0; i < nLinks; i++)
      {
         if ((Link[i].flavor & mask) == pattern)
            if (WriteNode(Link[i].addr, Buff, 0) >= MAX_ROUTE_LEN)
              {
                Spit(Buff);  // Spit out
                strcpy(Buff, Prefix);
                PrevNode = *MyNode; // Main aka
              }
      }
    if (strcmp(Buff, Prefix) != 0)
        Spit(Buff);
  }

local void
PutDownLinksGeneric(ushort UpIdx, ushort type, 
				ushort (*wrtnode)(nodeaddr,char*,ushort))
  {
    ushort i;
    for (i = 0; i < nNodes; i++)
      {
        if (Node[i].idx == UpIdx &&
            !DirectLink(i) &&
            !IsMyNode(Node[i].addr) &&
                  ( (UpIdx != WILDVALUE && Node[i].idx != i) ||
                    (UpIdx == WILDVALUE && Node[i].is_uplink) ) )
          {
            if (wrtnode(Node[i].addr, Buff, type) >= MAX_ROUTE_LEN)
              {
                if (UpNode.z != 0)
                  {
                    wrtnode(UpNode, Buff, 1);
                    PrevNode = *MyNode;
                  }
                Spit(Buff);  // Spit out
                strcpy(Buff, Prefix);
                if (UpIdx != WILDVALUE && UpNode.z == 0)
                    PrevNode = Node[UpIdx].addr;
              }
            if (FillRoute)   // Prevents duplication in 'Unrouted'
                Node[i].idx = 0;
            else
                PutDownLinksGeneric(i, type, wrtnode);
          }
      }
  }

local void
PutDownLinks(ushort UpIdx, ushort type)
  {
    ushort i;
    for (i = 0; i < nNodes; i++)
      {
        if (Node[i].idx == UpIdx &&
            !DirectLink(i) &&
            !IsMyNode(Node[i].addr) &&
                  ( (UpIdx != WILDVALUE && Node[i].idx != i) ||
                    (UpIdx == WILDVALUE && Node[i].is_uplink) ) )
          {
            if (WriteNode(Node[i].addr, Buff, type) >= MAX_ROUTE_LEN)
              {
                if (UpNode.z != 0)
                  {
                    WriteNode(UpNode, Buff, 1);
                    PrevNode = *MyNode;
                  }
                Spit(Buff);  // Spit out
                strcpy(Buff, Prefix);
                if (UpIdx != WILDVALUE && UpNode.z == 0)
                    PrevNode = Node[UpIdx].addr;
              }
            if (FillRoute)   // Prevents duplication in 'Unrouted'
                Node[i].idx = 0;
            else
                PutDownLinks(i, type);
          }
      }
  }

local char * RouteType[] =
  {
    "Nodes",
    "Nets",
    "Zones",
    "Default"
  };
local void
DirectsSQ(void)
  {
    PutDirects(CRASH_FLAVOR | NOARC_FLAVOR, CRASH_FLAVOR, "Send Crash  ");
    PutDirects(DIRECT_FLAVOR | NOARC_FLAVOR, DIRECT_FLAVOR, "Send Direct ");
    PutDirects(HOLD_FLAVOR | NOARC_FLAVOR, HOLD_FLAVOR, "Send Hold   ");
    PutDirects(NORMAL_FLAVOR | NOARC_FLAVOR, NORMAL_FLAVOR, "Send Normal ");
    PutDirects(CRASH_FLAVOR | NOARC_FLAVOR, CRASH_FLAVOR | NOARC_FLAVOR, "Send Crash  NoArc ");
    PutDirects(DIRECT_FLAVOR | NOARC_FLAVOR, DIRECT_FLAVOR | NOARC_FLAVOR, "Send Direct NoArc ");
    PutDirects(HOLD_FLAVOR | NOARC_FLAVOR, HOLD_FLAVOR | NOARC_FLAVOR, "Send Hold   NoArc ");
    PutDirects(NORMAL_FLAVOR | NOARC_FLAVOR, NORMAL_FLAVOR | NOARC_FLAVOR, "Send Normal NoArc ");
  }

local void
PutRoutingSq(void)
  {
    StarWild = false;
    AddPoint = false;
    DefaultFromMe = false;
    FullAddr = false;
    FillRoute = false;
    WithSlash = false;

    fprintf(NewRoute, CREATED,';',"Squish", MyNode->z, MyNode->n, MyNode->f,
                                             ';',ctime(&currtime),';');

    Spit("; *** Direct links"EOLCHR";");
    DirectsSQ();

    Spit(";"EOLCHR"; *** Route"EOLCHR";");

    for (level = 0; level < 4; level++)
      {
        fprintf(NewRoute, "; *** %s"EOLCHR"", RouteType[level]);
        if (level)
            DirectsSQ();
        for (ushort i = 0; i < nLinks; i++)
          {
            MakeSqPrefix(Link+i, Prefix);
            strcpy(Buff, Prefix);
            PutDownLinks(InMemory(Link[i].addr), 0);
            if (strcmp(Buff, Prefix) != 0)
                Spit(Buff); // Spit short but significant line
          }
      }
  }

//
//   Make Routing for ITrack
//
char * ItrFlavors[] =
  {
    "Crash", "Dir  ", "Hold ", "     "
  };

local void
PutRoutingItr(void)
  {
    StarWild = true;
    AddPoint = true;
    DefaultFromMe = false;
    FullAddr = true;
    FillRoute = false;
    WithSlash = false;

    fprintf(NewRoute, CREATED,';',"iTrack", MyNode->z,MyNode->n,MyNode->f,
                                             ';',ctime(&currtime),';');
    for (level = 0; level < 4; level++)
      {
	int i;
        fprintf(NewRoute, "; *** %s"EOLCHR"", RouteType[level]);

        for (i = 0; i < nLinks; i++)
          {
            strcpy(Prefix, GetFlavor(Link+i, ItrFlavors));
            
            WriteNode(Link[i].addr, Prefix, 1);
            strcat(Prefix, "  ");
            strcpy(Buff, Prefix);
            WriteNode(Link[i].addr, Buff, 0);
            PutDownLinks(InMemory(Link[i].addr), 0);
            if (strcmp(Buff,Prefix) != 0) // We added any downlinks
                Spit(Buff); // Spit short but significant line
          }
      }
  }

//
//   Make Routing for T-mail
//
local void
DirectsTmail(void)
  {
    AddPoint = true;
    PrevNode = *MyNode; // Main AKA

    PutDirects(CRASH_FLAVOR, CRASH_FLAVOR, "Direct ");
    PutDirects(DIRECT_FLAVOR, DIRECT_FLAVOR, "Direct ");
    PutDirects(NORMAL_FLAVOR, NORMAL_FLAVOR, "Direct ");
    PutDirects(HOLD_FLAVOR, HOLD_FLAVOR, "Direct ");

    AddPoint = false;

    PutDirects(CRASH_FLAVOR, CRASH_FLAVOR, "Priority ");
    PutDirects(HOLD_FLAVOR, HOLD_FLAVOR, "Hold ");
  }

local void
PutRoutingTmail(void)
  {
    StarWild = true;
    AddPoint = false;
    DefaultFromMe = true;
    FullAddr = false;
    FillRoute = false;
    WithSlash = true;

    fprintf(NewRoute, CREATED, ';', "T-mail", MyNode->z, MyNode->n, MyNode->f,
                                             ';',ctime(&currtime),';');

    Spit("; *** Direct links");
    DirectsTmail();

    for (level = 0; level < 4; level++)
      {
        fprintf(NewRoute, "; *** %s"EOLCHR"", RouteType[level]);
        if (level)
            DirectsTmail();
	int i;
        for (i = 0; i < nLinks; i++)
          {
            if (TmailAddFor)
                strcpy(Prefix, "Mail-For  ");
            else
                strcpy(Prefix, "Mail  ");
            strcpy(Buff, Prefix);
            UpNode = Link[i].addr;
            PutDownLinks(InMemory(Link[i].addr), 0);
            if (strcmp(Buff, Prefix) != 0)
              {
                WriteNode(UpNode, Buff, 1);
                Spit(Buff); // Spit short but significant line
              }
          // 'Files'
            if (Link[i].flavor & FILE_FLAVOR)
              {
                if (TmailAddFor)
                    strcpy(Prefix, "Files-For ");
                else
                    strcpy(Prefix, "Files ");
                strcpy(Buff, Prefix);
                UpNode = Link[i].addr;
                PutDownLinks(InMemory(Link[i].addr), 0);
                if (strcmp(Buff, Prefix) != 0)
                  {
                    WriteNode(UpNode, Buff, 1);
                    Spit(Buff); // Spit short but significant line
                  }
              }
          }
      }
  }

//
//   Make Routing for BPACK
//
local void
DirectsBpack(void)
  {
    PrevNode = *MyNode;

    PutDirects(CRASH_FLAVOR, CRASH_FLAVOR,   "Direct crash  ");
    PutDirects(DIRECT_FLAVOR, DIRECT_FLAVOR, "Direct direct ");
    PutDirects(NORMAL_FLAVOR, NORMAL_FLAVOR, "Direct        ");
    PutDirects(HOLD_FLAVOR, HOLD_FLAVOR,     "Direct hold   ");
    PutDirects(NOARC_FLAVOR, NOARC_FLAVOR,   "NoArcSend     ");
  }

local void
PutRoutingBpack(void)
  {
    StarWild = true;
    AddPoint = false;
    DefaultFromMe = false;
    FullAddr = true;
    FillRoute = false;
    WithSlash = false;

    fprintf(NewRoute, CREATED, ';', "BPack", MyNode->z, MyNode->n, MyNode->f,
                                             ';',ctime(&currtime),';');

    Spit("; *** Direct links");
    DirectsBpack();

    for (level = 0; level < 4; level++)
      {
        fprintf(NewRoute,"; *** %s"EOLCHR"", RouteType[level]);
        if (level)
            DirectsBpack();
	int i;
        for (i = 0; i < nLinks; i++)
          {
            strcpy(Prefix, "Route ");
            strcat(Prefix, GetFlavor(Link+i, SqFlavors));
            WriteNode(Link[i].addr, Prefix, 1);
            strcat(Prefix, " ");

            strcpy(Buff, Prefix);
            PutDownLinks(InMemory(Link[i].addr), 0);
            if (strcmp(Buff, Prefix) != 0)
                Spit(Buff); // Spit short but significant line
          }
      }
  }

//
//   Make Routing for IMBINK
//
local void
PutRoutingImb(void)
  {
    StarWild = true;
    AddPoint = true;
    DefaultFromMe = false;
    FullAddr = false;
    FillRoute = false;
    WithSlash = false;
    CmntSym = '#';
    fprintf(NewRoute, CREATED,'#',"Imbink", MyNode->z,MyNode->n,MyNode->f,
                                             '#',ctime(&currtime),'#');
    PutDirects(FILE_FLAVOR, FILE_FLAVOR, "FSENDTO ");
    PutDirects(NOARC_FLAVOR,0, "Compress ZIP ");

    for (level = 0; level < 4; level++)
      {
        fprintf(NewRoute, "# *** %s"EOLCHR"", RouteType[level]);
	int i;
        for (i = 0; i < nLinks; i++)
          {
            strcpy(Prefix, "Static ");
            strcat(Prefix, GetFlavor(Link+i,SqFlavors));

            WriteNode(Link[i].addr, Prefix, 1);
            strcat(Prefix, "  ");
            strcpy(Buff, Prefix);
            WriteNode(Link[i].addr, Buff, 0);
            PutDownLinks(InMemory(Link[i].addr), 0);
            if (strcmp(Buff, Prefix) != 0)
                Spit(Buff); // Spit short but significant line
          }
      }
  }

//
//   Make Routing for XMAIL
//
local void
PutRoutingXmail(void)
  {
    StarWild = false;
    AddPoint = false;
    DefaultFromMe = false;
    FullAddr = true;
    FillRoute = false;
    WithSlash = false;
    CmntSym = ';';


    fprintf(NewRoute, CREATED,';',"Xmail", MyNode->z,MyNode->n,MyNode->f,
                                             ';',ctime(&currtime),';');

    fprintf(NewRoute, "; *** Directs"EOLCHR"");
    level = 0;
    int i;
    for (i = 0; i < nLinks; i++)
      {
        Buff[0] = 0;
        WriteNode(Link[i].addr, Buff, 0);
        if (Buff[0])
            Spit(Buff+1);
      }

    for (level = 0; level < 4; level++)
      {
        fprintf(NewRoute, "; *** %s"EOLCHR"", RouteType[level]);

	ushort i;
        if (level) {
            for (i = 0; i < nLinks; i++)
              {
                Buff[0] = 0;
                WriteNode(Link[i].addr, Buff, 0);
                if (Buff[0])
                    Spit(Buff+1);
              }
	}

        for (i = 0; i < nNodes; i++)
          {
            Buff[0] = 0;
            if (Node[i].idx != WILDVALUE && Node[i].idx != (WILDVALUE-1) &&
                                       !DirectLink(i))
              {
                WriteNode(Node[i].addr, Buff, 0);
                if (Buff[0])
                  {
                    strcat(Buff, " VIA ");
                    WriteNode(Node[Node[i].idx].addr, Buff, 1);
                    strcat(Buff, " /NC");
                    Spit(Buff+1);
                  }
              }
          }
      }
  }

//
//   Make Routing for ifmail
//
local char *
GetIfFlavor(link * pLink)
  {
    if (pLink->flavor & CRASH_FLAVOR)
        return "c";
    else if (pLink->flavor & DIRECT_FLAVOR)
        return "n";
    else if (pLink->flavor & HOLD_FLAVOR)
        return "h";
    else
        return "n";
  }

local char *
AddInt(char * where, ushort value)
  {
    itoa(value, where, 10);
    return (where + strlen(where));
  }

local boolean
WriteIfNode(nodeaddr Node, char * out, ushort wmode)
  {
    char * p = out+strlen(out);
    ushort wildlevel = 0;

    if (Node.f == WILDVALUE)
        wildlevel++;
    if (Node.n == WILDVALUE)
        wildlevel++;
    if (Node.z == WILDVALUE)
        wildlevel++;

    if ( wildlevel == level || wmode)
      {
        if (Node.f != WILDVALUE)
          {
            *p++ = 'f';
            p = AddInt(p, Node.f);
            *p = '.';
            *(++p) = '\0';
          }
        if (Node.n != WILDVALUE)
          {
            *p++ = 'n';
            p = AddInt(p, Node.n);
            *p = '.';
            *(++p) = '\0';
          }
        if (Node.z != WILDVALUE)
          {
            *p++ = 'z';
            p = AddInt(p, Node.z);
	    *p++ = '.';
          }

        strcpy(p, "fidonet.org");
        return true;
      }
    else
        return false;
  }

local void
PutRoutingIfmail(void)
  {
    StarWild = false;
    AddPoint = false;
    DefaultFromMe = false;
    FullAddr = true;
    FillRoute = false;
    WithSlash = false;
    CmntSym = '#';


    fprintf(NewRoute, CREATED,'#',"sendmail", MyNode->z,MyNode->n,MyNode->f,
                                             '#',ctime(&currtime),'#');

    for (level = 0; level < 4; level++)
      {
        fprintf(NewRoute, "# *** %s"EOLCHR"", RouteType[level]);
	ushort i;
        for (i = 0; i < nNodes; i++)
          {
            Buff[0] = 0;
            if (Node[i].idx != WILDVALUE &&       // routed
                Node[i].idx != (WILDVALUE-1) &&   // not joined with wildcard
                 ( Node[Node[i].idx].idx != WILDVALUE &&
                   Node[Node[i].idx].idx != WILDVALUE-1 ||
		   DirectLink(Node[i].idx)
		 ) &&
                !IsMyNode(Node[Node[i].idx].addr) ||
                DirectLink(i)
               )
              {
                strcpy(Buff, ".");
                if (WriteIfNode(Node[i].addr, Buff,0))
                  {
                    listitem Dest;

                    strcat(Buff, "\tifmail-");
                    Dest = DirectLink(i) ? Node[i] : Node[Node[i].idx];

		    int j;
                    for (j = 0; j < nLinks; j++)
                        if (Link[j].addr == Dest.addr)
                            strcat(Buff, GetIfFlavor(Link+j));
                    strcat(Buff, ":");
                    WriteIfNode(Dest.addr, Buff,1);

                    if (!level)
                        Spit(Buff+1);
                    Spit(Buff);
                  }
              }
          }
      }
  }

//
//   Make Routing for BiP
//
char * BipFlavors[] =
  {
    "Crash", "Dir  ", "Hold ", "Norm "
  };

local void
PutRoutingBip(void)
  {
    StarWild = true;
    AddPoint = true;
    DefaultFromMe = true;
    FullAddr = false;
    FillRoute = false;
    WithSlash = false;

    fprintf(NewRoute, CREATED,';',"BiP", MyNode->z,MyNode->n,MyNode->f,
                                             ';',ctime(&currtime),';');
    for (level = 3; level != 0xFFFF; level--)
      {
        fprintf(NewRoute, "; *** %s"EOLCHR"", RouteType[level]);
	int i;
        for (i = 0; i < nLinks; i++)
          {
            strcpy(Prefix, "Route");
            strcat(Prefix, GetFlavor(Link+i, BipFlavors));
            WriteNode(Link[i].addr, Prefix, 1);
            strcat(Prefix, "  ");
            strcpy(Buff, Prefix);
            WriteNode(Link[i].addr, Buff, 0);
            PutDownLinks(InMemory(Link[i].addr), 0);
            if (strcmp(Buff, Prefix) != 0)
                Spit(Buff); // Spit short but significant line
            
            if (Link[i].flavor & FILE_FLAVOR)
              {    
                strcpy(Prefix, "File");
                strcat(Prefix, GetFlavor(Link+i, BipFlavors));
                WriteNode(Link[i].addr, Prefix, 1);
                strcat(Prefix, "  ");
                strcpy(Buff, Prefix);
                WriteNode(Link[i].addr, Buff, 0);
                PutDownLinks(InMemory(Link[i].addr), 0);
                if (strcmp(Buff, Prefix) != 0)
                    Spit(Buff); // Spit short but significant line
              }   
          }
      }
  }

//
//   Make Routing for Unimail
//
local void
PutRoutingUnimail(void)
  {
    StarWild = true;
    AddPoint = true;
    DefaultFromMe = false;
    FullAddr = true;
    FillRoute = false;
    WithSlash = false;

    fprintf(NewRoute, CREATED,';',"Unimail", MyNode->z, MyNode->n, MyNode->f,
                                             ';',ctime(&currtime),';');
    Spit(";"EOLCHR"; *** Route"EOLCHR";");

    for (level = 0; level < 4; level++)
      {
        fprintf(NewRoute, "; *** %s"EOLCHR"", RouteType[level]);
	int i;
        for (i = 0; i < nLinks; i++)
          {
            strcpy(Prefix, "Route");
            strcat(Prefix, GetFlavor(Link+i, SqFlavors));
            WriteNode(Link[i].addr, Prefix, 1);
            strcpy(Buff, Prefix);
            WriteNode(Link[i].addr, Buff, 0);
            PutDownLinks(InMemory(Link[i].addr), 0);
            if (strcmp(Buff, Prefix) != 0)
                Spit(Buff); // Spit short but significant line
          }
      }
  }

//
//   Make Routing for QECHO
//

ushort
WriteNodeQecho(nodeaddr Node, char * out, ushort addrtype) {

	char tmp[20];
	ushort wildlevel = 0;
	if (Node.f == WILDVALUE)
		wildlevel++;
	if (Node.n == WILDVALUE)
		wildlevel++;
	if (Node.z == WILDVALUE)
		wildlevel++;

	if ( wildlevel == level || addrtype == 1) {
		if (wildlevel == 3) {
			strcat(out, "1: 2: 3: 4: 5: 6: 7:");
		} else {
        	        strcat(out, " ");
	                strcat(out, itoa(Node.z,tmp,10));
        	        strcat(out, ":");
			if (wildlevel < 2) {
		                strcat(out, itoa(Node.n,tmp,10));
			}
			if (wildlevel < 1) {
	        	        strcat(out, "/");
		                strcat(out, itoa(Node.f,tmp,10));
			}
		}
	}
	return ushort(strlen(out));
}

local void
PutRoutingQecho(void) {
    StarWild = false;
    AddPoint = false;
    DefaultFromMe = false;
    FullAddr = true;
    FillRoute = false;
    WithSlash = false;
    CmntSym = '#';
	MAX_ROUTE_LEN = 100;
	fprintf(NewRoute, CREATED,'#',"QECHO", MyNode->z, MyNode->n, MyNode->f,
                                             '#',ctime(&currtime),'#');
	Spit("#"EOLCHR"# *** Route"EOLCHR"#");

    for (level = 0; level < 3; level++)
      {
        fprintf(NewRoute, "# *** %s"EOLCHR"", RouteType[level]);
	int i;
        for (i = 0; i < nLinks; i++)
          {
            sprintf(Prefix, "RouteVia\t%d:%d/%d@fidonet"EOLCHR"RouteFor\t",
			Link[i].addr.z,Link[i].addr.n,Link[i].addr.f);
	    strcpy(Buff, Prefix);
	    if (level == 0) {
		WriteNodeQecho(Link[i].addr, Buff, 1);
	    }
            PutDownLinksGeneric(InMemory(Link[i].addr), 0, WriteNodeQecho);
            if (strcmp(Buff, Prefix) != 0) {
                Spit(Buff); // Spit non-empty line
	    }
          }
      }
}

//
//   Make Routing for Fidogate
//
char * FidogateFlavors[] =
  {
    "crash ", "direct", "hold  ", "normal"
  };
local void
MakeFidogatePrefix(link * pLink, char * out)
  {
    strcpy(out, "route ");

    strcat(out, GetFlavor(pLink, FidogateFlavors));

    if (pLink->flavor & FILE_FLAVOR)
        strcat(out, " file");
    else
        strcat(out, "     ");

    if (pLink->flavor & NOARC_FLAVOR)
        strcat(out, " noarc");
    else
        strcat(out, "      ");

     WriteNode(pLink->addr, out, 1);
     strcat(out, " ");
  }

local void
DirectsFidogate(void)
  {
    PutDirects(CRASH_FLAVOR, CRASH_FLAVOR, "send crash  ");
    PutDirects(DIRECT_FLAVOR, DIRECT_FLAVOR, "send direct ");
    PutDirects(HOLD_FLAVOR, HOLD_FLAVOR, "send hold   ");
    PutDirects(NORMAL_FLAVOR, NORMAL_FLAVOR, "send normal ");
  }

local void
PutRoutingFidogate(void)
  {
    StarWild = false;
    AddPoint = false;
    DefaultFromMe = false;
    FullAddr = true;
    FillRoute = false;
    WithSlash = false;
    CmntSym = '#';
    
    fprintf(NewRoute, CREATED,CmntSym,"Fidogate", MyNode->z, MyNode->n, MyNode->f,
                                             '#',ctime(&currtime),'#');

    Spit("# *** Direct links"EOLCHR"#");
    DirectsFidogate();

    Spit("#"EOLCHR"# *** Route"EOLCHR"#");

    for (level = 0; level < 4; level++)
      {
        fprintf(NewRoute, "# *** %s"EOLCHR"", RouteType[level]);
        if (level)
            DirectsFidogate();
        for (ushort i = 0; i < nLinks; i++)
          {
            MakeFidogatePrefix(Link+i, Prefix);
            strcpy(Buff, Prefix);
            PutDownLinks(InMemory(Link[i].addr), 0);
            if (strcmp(Buff, Prefix) != 0)
                Spit(Buff); // Spit short but significant line
          }
      }
  }

//
//   Make Routing for FTRACK
//
local int counter=0;
ushort
WriteNodeFtrack(nodeaddr Node, char * out, ushort addrtype) {
	static const char * prefix = "Mask: * * * ";
	static const char * postfix = " * *";

    ushort wildlevel = 0;
    if (Node.f == WILDVALUE)
        wildlevel++;
    if (Node.n == WILDVALUE)
        wildlevel++;
    if (Node.z == WILDVALUE)
        wildlevel++;
    if ( wildlevel == level || addrtype == 1) {
        counter++;
	strcpy(out, prefix);
	if (level == 3)
		strcat(out,"*");
	else
	        WriteNode(Node, out+strlen(prefix), addrtype);
	strcat(out, postfix);
    }
	return ushort(strlen(out));
}
local void
PutRoutingFtrack(void) {
    StarWild = true;
    AddPoint = true;
    DefaultFromMe = true;
    FullAddr = true;
    FillRoute = false;
    WithSlash = true;
    CmntSym = '\\';

    MAX_ROUTE_LEN = 10;


	fprintf(NewRoute, CREATED,CmntSym,"Ftrack", MyNode->z, MyNode->n, MyNode->f,
                                             CmntSym,ctime(&currtime),CmntSym);
    for (level = 0; level < 4; level++){
	counter = 0;
        fprintf(NewRoute, "%c *** %s"EOLCHR"", CmntSym, RouteType[level]);
	int i;
        for (i = 0; i < nLinks; i++)
          {
	    counter = 0;
	    Buff[0] = 0;
	    if (level == 0) {
		WriteNodeFtrack(Link[i].addr, Buff, 0);
		Spit(Buff);
		counter++;
		Buff[0] = 0;
	    }
            PutDownLinksGeneric(InMemory(Link[i].addr), 0, WriteNodeFtrack);
	    if (counter) {
		sprintf(Buff, "Action: Route %s", GetFlavor(Link+i, SqFlavors));
		AddPoint = false;
		WriteNode(Link[i].addr, Buff, 1);
		AddPoint = true;
		strcat(Buff,"\n\\");
		Spit(Buff);
	    }
          }
      }
}

//-----------------------------------------------------------------
local void
PutUnRouted(void)
  {
    FillRoute = true;
    FullAddr = true;

    fprintf(NewRoute,"%c"EOLCHR"%c !!! Unrouted !!!"EOLCHR"%c ----------------"EOLCHR"",
                             CmntSym,CmntSym,CmntSym);
    level = 0;
    Prefix[0]=CmntSym;
    Prefix[1]=0;
    strcat(Prefix, " >>> ");
    strcpy(Buff, Prefix);
    PutDownLinks(WILDVALUE, 0);
    if (strcmp(Buff, Prefix) != 0)
        Spit(Buff); // Spit short but significant line
  }


//
//   Config parser
//

local boolean
LoadAddress(char * p, void *)
  {
    MyNode[nAKAs++] = ScanNode(&p);
    return true;
  }

local boolean
GetRouteType(char * p, void *)
  {
    if (strnicmp(p, "squish", 6) == 0)
        RouteMode = SQUISH;
    else if (strnicmp(p, "itrack", 6) == 0)
        RouteMode = ITRACK;
    else if (strnicmp(p, "tmail", 5) == 0)
      {
        RouteMode = TMAIL;
        if ((strnicmp(p, "tmailn", 6) == 0))
           TmailAddFor = true;
        else
           TmailAddFor = false;
      }
    else if (strnicmp(p, "bpack", 5) == 0)
        RouteMode = BPACK;
    else if (strnicmp(p, "imbink", 6) == 0)
        RouteMode = IMBINK;
    else if (strnicmp(p, "xmail", 5) == 0)
        RouteMode = XMAIL;
    else if (strnicmp(p, "ifmail", 6) == 0)
        RouteMode = IFMAIL;
    else if (strnicmp(p, "bip", 3) == 0)
        RouteMode = BIP;
    else if (strnicmp(p, "unimail", 7) == 0)
        RouteMode = UNIMAIL;
    else if (strnicmp(p, "qecho", 5) == 0)
        RouteMode = QECHO;
    else if (strnicmp(p, "fidogate", 8) == 0)
        RouteMode = FIDOGATE;
    else if (strnicmp(p, "ftrack", 6) == 0)
        RouteMode = FTRACK;
    else
      {
        ErrorL(ErrUnknownRouteType);
        return false;
      }
    return true;
  }

local boolean
GetBoolean(char * p, void * target)
  {
    if (strnicmp(p, "yes", 3) == 0 || strnicmp(p, "on", 2) == 0)
        *(ushort*)target = 1;
    else if (strnicmp(p, "no", 2) == 0 || strnicmp(p, "off", 3) == 0)
        *(ushort*)target = 0;
    else
      {
        ErrorL(ErrUnknownMinType);
        return false;
      }
    return true;
  }

local boolean
GetFile(char * p, void * Name)
  {
    char * p1 = (char *)Name;

    while(!isspace(*p))
        *(p1++) = *(p++);
    *p1 = 0;
    return true;
  }

local boolean
GetQuotedString(char * p, void * str)
  {
    char * p1 = (char *)str;
    if (*p == '\"')
      {
        p++;
        while (*p != '\"')
          {
            if (*p == '\n' || *p == '\0')
              {
                ErrorL(ErrQuoteString);
                return false;
              }
            else
                *(p1++) = *(p++);
          }
        *p1 = 0;
      }
    return true;
  }

local boolean
GetDestFile(char * p, void * Name)
  {
    GetFile(p, Name);
    if ((OldRoute = fopen((char*)Name, "rt")) == NULL)
       {
        Error(ErrOpenDest);
        return false;
      }
#if !defined(__GNUC__)
    fnsplit((char*)Name, OutDrv, OutDir, OutName, OutExt);
    fnmerge(TempFile, OutDrv, OutDir, "MK$ROUTE", "$$$");
#else
    strcpy(TempFile, (char*)Name);
    strcat(TempFile, ".$$$");
#endif
    if ((NewRoute = fopen(TempFile, "wt")) == NULL)
      {
        Error(ErrOpenTmp);
        return false;
      }

    boolean ReplaceArea = false;
    size_t beglen = strlen(RouteBegin);
    size_t endlen = strlen(RouteEnd);

    while (fgets(Buff, BUFFLEN-1, OldRoute))
      {
        if (!ReplaceArea)
            fputs(Buff, NewRoute);
        if (strncmp(Buff, RouteBegin, beglen) == 0)
            ReplaceArea = true;

        if (ReplaceArea && (strncmp(Buff, RouteEnd, endlen) == 0))
            return true;
      }
    Error(ReplaceArea ? ErrNoReplEnd : ErrNoReplBeg);
    fclose(OldRoute);
    fclose(NewRoute);
    unlink(TempFile);
    return false;
  }

local boolean
GetFlavor(char * p, void * mask)
  {
    while (*p != '\n' && *p != '\0' && *p != ';')
      {
        if (tolower(*p) == 'd')
            *(ushort*)mask |= DIRECT_FLAVOR;
        else if (tolower(*p) == 'c')
            *(ushort*)mask |= CRASH_FLAVOR;
        else if (tolower(*p) == 'h')
            *(ushort*)mask |= HOLD_FLAVOR;
        else if (tolower(*p) == 'n')
            *(ushort*)mask |= NORMAL_FLAVOR;
        else if (tolower(*p) == 'f')
            *(ushort*)mask |= FILE_FLAVOR;
        else if (tolower(*p) == 'a')
            *(ushort*)mask |= NOARC_FLAVOR;
        p++;
      }
    if ((*(ushort*)mask &
             (DIRECT_FLAVOR | CRASH_FLAVOR | HOLD_FLAVOR)) == 0)
        *(ushort*)mask |= NORMAL_FLAVOR;
    return true;
  }

local boolean
GetLink(char * p, void *)
  {
    memset(Link+nLinks, 0, sizeof (Link[0]));
    Link[nLinks].addr = ScanNode(&p);
    GetFlavor(p, &Link[nLinks].flavor);

    if (InMemory(Link[nLinks].addr) == WILDVALUE) // Not in Node[]
      {
        Node[nNodes].addr = Link[nLinks].addr;
        Node[nNodes++].idx = WILDVALUE;
      }

    nLinks++;
    return true;
  }

local ushort
StoreUplink(nodeaddr tmpNode)
  {
    ushort Uplink = InMemory(tmpNode);

    if (Uplink == WILDVALUE) // Not in memory yet
      {
        Uplink = nNodes;
        Node[nNodes].addr = tmpNode;
        Node[nNodes].is_uplink = true;
        Node[nNodes++].idx = WILDVALUE;
      }
    return Uplink;
  }

local void
StoreDownLink(ushort Uplink, nodeaddr tmpNode)
  {
    if (!IsMyNode(tmpNode))
      {
        ushort Downlink = InMemory(tmpNode);
        if (!(Downlink == Uplink))
          {
            if (Downlink == WILDVALUE) // New node
              {
                Downlink = nNodes;
                Node[nNodes].addr = tmpNode;
                Node[nNodes++].idx = Uplink;
              }
            else
              {
                if (Node[Downlink].idx != WILDVALUE && // Already routed
                    Node[Downlink].idx != Uplink) // differently
                  {
                    ErrorS(ErrReroute, StrNode(tmpNode));
                  }
                Node[Downlink].idx = Uplink;
              }
            Node[Downlink].is_uplink = false;
          }
      }
  }

local boolean
GetRouteStr(char * p, void*)
  {
    boolean ViaRoute;

    skipws(&p);
    if (!(*p == ';' || *p == '\n' || *p == '\0'))
      {
        PrevNode = *MyNode; // Main AKA
        if (*p == '>')   // 'via'-routing
          {
            p++;
            skipws(&p);
            ViaRoute = true;
          }
        else
            ViaRoute = false;

        nodeaddr tmpNode = ScanNode(&p);

        if (ViaRoute) {
		if( IsMyNode(tmpNode) ) {           
            		tmpNode = ScanNode(&p); // skip myself
			StoreDownLink(StoreUplink(MyNode[0]), tmpNode);
		} else if (KillTransit) {
		        ScanNode(&p);	// skip transit node
		}
	}

        ushort Uplink = StoreUplink(tmpNode);

        while(*p != '\n' && *p != '\0' && *p != ';')
          {
            tmpNode = ScanNode(&p);
            StoreDownLink(Uplink, tmpNode);
            skipws(&p);
          }
      }
    return true;
  }

local boolean
GetRouteFile(char * p, void *)
  {
    char Name[100];
    GetFile(p, Name);
    FILE * nodes;
    if ((nodes = fopen(Name, "rt")) != NULL)
      {
        fprintf(stderr, ""EOLCHR"Scanning route file %s...", Name);
        while (fgets(Buff, BUFFLEN, nodes))
            GetRouteStr(Buff,NULL);

        fclose(nodes);
        return true;
      }
    else
      {
        ErrorL(ErrNoFile);
        return false;
      }
  }

local boolean
GetTrustStr(char * p, void*)
  {

    if (!(*p == ';' || *p == '\n' || *p == '\0'))
      {
        PrevNode = *MyNode; // Main AKA
        nodeaddr tmpNode = ScanNode(&p); // scan network


        while(*p != '\n' && *p != '\0' && *p != ';')
          {
            nodeaddr TrustedNode = ScanNode(&p);
            if (DirectLink(TrustedNode)) 
              {
                ushort idx = StoreUplink(TrustedNode);
                StoreDownLink(idx, tmpNode);
              }
            skipws(&p);
          }
      }
    return true;
  }

local boolean
GetTrustFile(char * p, void *)
  {
    char Name[100];
    GetFile(p, Name);
    FILE * nodes;
    if ((nodes = fopen(Name, "rt")) != NULL)
      {
        fprintf(stderr, ""EOLCHR"Scanning route file %s...", Name);
        while (fgets(Buff, BUFFLEN, nodes))
            GetTrustStr(Buff,NULL);

        fclose(nodes);
        return true;
      }
    else
      {
        ErrorL(ErrNoFile);
        return false;
      }
  }

local ushort GlukCnt = 0;
local void
DrawGluk(void)
  {
    const char * Gluk = "-\\|/";
    putc(Gluk[GlukCnt++], stderr) ;
    putc('\b',stderr);
    if (GlukCnt > 3)
        GlukCnt = 0;
  }
local boolean
GetHubRoute(char *p, void *)
  {
    char Name[100];
    FILE * ndl;

    strcpy(Name, strtok(p, " \t"));
#if !defined(__GNUC__)
    fnsplit(Name, OutDrv, OutDir, OutName, OutExt);
#endif
    if (strchr(Name, '?') || strchr(Name, '*'))
      {
        short maxext = (-1);
        short ext;
#if defined (__TSC__)
        int rc;
        ffblk ff;
        for (rc = findfirst(Name, &ff, 0); rc != (-1); rc = findnext(&ff))
          {
            char bb[MAXFILE];
            strcpy(bb,ff.ff_name);
            *(strrchr(bb,'.')) = '\0';
            char * p1 = bb;
            char * p2 = bb + strlen(bb) + 1;
            ext = atoi(p2);
            if (ext > maxext)
              {
                maxext = ext;
                strcpy(OutName, p1);
                strcpy(OutExt, p2);
              }
          }
#elif defined (__WATCOMC__)
        DIR * ff;
        if ( (ff = opendir(Name)) != 0)
          {
            while (readdir(ff) != NULL)
              {
                char bb[MAXFILE];
                strcpy(bb,ff->d_name);
                *(strrchr(bb,'.')) = '\0';
                char * p1 = bb;
                char * p2 = bb + strlen(bb) + 1;
                ext = (short)atoi(p2);
                if (ext > maxext)
                  {
                    maxext = ext;
                    strcpy(OutName, p1);
                    strcpy(OutExt, p2);
                  }
              }
            closedir(ff);
          }
#endif
#if defined (__GNUC__)
        if (!glob(Name, GLOB_ERR, NULL, &globbuf))
            maxext = 0;
#endif
        if (maxext > (-1))      // found!
#if !defined(__GNUC__)
            fnmerge(Name, OutDrv, OutDir, OutName, OutExt);
#else
          {
            strcpy(Name, globbuf.gl_pathv[globbuf.gl_pathc-1]);
            globfree(&globbuf);
          }
#endif
        else
          {
            ErrorL(ErrNoFile);
            return false;
          }
      }

    if ((ndl = fopen(Name, "rt")) == NULL)
      {
        ErrorL(ErrNoFile);
        return false;
      }
    else
      {
        setvbuf(ndl, NULL, _IOFBF, 0x8000); // Max buffering for speed
        char * p1 = strtok(NULL, " \t"); // possible ndl type
        if (strlen(p1) != 1)
          {
            ErrorL(ErrBadNdlType);
            fclose(ndl);
            return false;
          }
        else
          {
            ushort level, found = 0, z, n, f, Uplink;

            switch (toupper(*p1))
              {
                case 'Z': level = 0; break;
                case 'R':
                case 'N': level = 1; found = 1; break;
                default:
                    ErrorL(ErrBadNdlType);
                    fclose(ndl);
                    return false;
              }
            p1 = strtok(NULL, " \t");
            if (p1 == NULL )
              {
                ErrorL(ErrBadNdlType);
                fclose(ndl);
                return false;
              }
            ushort mz = (ushort)atoi(p1);

            p1 = strtok(NULL, " \t");
            if (p1 == NULL )
              {
                ErrorL(ErrBadNdlType);
                fclose(ndl);
                return false;
              }
            ushort mn = (ushort)atoi(p1);

            fprintf(stderr, ""EOLCHR"Scanning nodelist %s for %d:%d hubroute...",
                                       Name, mz, mn);
            ushort count = 0;
            ushort step = level ? 20 : 1000;
            while (fgets(Buff, BUFFLEN, ndl) != NULL)
              {
                if (++count > step)
                  {
                    DrawGluk();
                    count = 0;
                  }
                if (Buff[0] != ';')
                  {
                    if (level == 0 && strnicmp(Buff, "zone",4) == 0)
                        {
                          found = 0;
                          if ((z = (ushort)atoi(Buff+5)) == mz)
                              found |= 0x01;
                        }
                    else if ((found&0x01) && strnicmp(Buff, "region",6) == 0)
                        {
                          found &= 0x01;
                          if ((n = (ushort)atoi(Buff+7)) == mn)
                              found |= 0x02;
                        }
                    else if ((found&0x01) && strnicmp(Buff, "host",4) == 0)
                        {
                          found &= 0x01;
                          if ((n = (ushort)atoi(Buff+5)) == mn)
                              found |= 0x02;
                        }
                    else if ((found & 0x3) == 3 && strnicmp(Buff, "hub",3) == 0)
                        {
                          found &= 0x03;
                          f = (ushort)atoi(Buff+4);
                          found |= 0x04;
                        }
                     else if ((found & 0x03) == 3)
                        {
                          found |= 0x08;
                          if (strnicmp(Buff, "pvt",3) == 0)
                              f = (ushort)atoi(Buff+4);
                          else if ((strnicmp(Buff, "hold",4) == 0) ||
                                                  (strnicmp(Buff, "down",4) == 0))
                              f = (ushort)atoi(Buff+5);
                          else if (Buff[0] == ',')
                              f = (ushort)atoi(Buff+1);
                          else
                            {
                              found &= 7;
                              continue;
                            }
                        }
                    if (found == 3) // host routing
                        Uplink = StoreUplink(nodeaddr(level ? mz : z, n, 0));
                    else if (found == 7) // hub routing
                        Uplink = StoreUplink(nodeaddr(level ? mz : z, n, f));
                    else if (found >= 0x0B) // node
                        StoreDownLink(Uplink, nodeaddr(level ? mz : z, n, f));
                  }
              }
          }
      }
    fclose(ndl);
    return true;
  }

#define CFG_PASSES 6

local CfgValue CfgTab[] =
  {
    { "Address",        NULL,           1,      LoadAddress },
    { "Hubroute",       NULL,           3,      GetHubRoute },
    { "RouteFile",      NULL,           3,      GetRouteFile },
    { "TrustFile",      NULL,           4,      GetTrustFile },
    { "RouteType",      &RouteMode,     1,      GetRouteType },
    { "WriteTo",        WriteTo,        2,      GetDestFile },
    { "Minimize",       &MinMode,       1,      GetBoolean },
    { "KillTransit",    &KillTransit,   1,      GetBoolean },
    { "LogFile",        LogFile,        0,      GetFile },
    { "DefaultFlavor",  &DefaultFlavor, 2,      GetFlavor },
    { "DefaultRoute",   NULL,           5,      GetRouteStr },
    { "Link",           NULL,           2,      GetLink },
    { "RouteBegin",     RouteBegin,     1,      GetQuotedString},
    { "RouteEnd",       RouteEnd,       1,      GetQuotedString}
  };
local boolean
PassOK(ushort Pass)
  {
    switch (Pass)
      {
        case 0:
         // Existing log file ( 䨣, p訢???)
//            if (LogFile[0] == '\0')
//                return false;
            break;
        case 1:
         // Existing main address
            if (MyNode->z == 0 || MyNode->n == 0)
              {
                Error(ErrMissMainAddr);
                return false;
              }
         // Existing RouteType keyword
            if (!RouteMode)
              {
                Error(ErrMissRouteType);
                return false;
              }
         // Existing "Minimize"
            if (MinMode == 2)
                Error(ErrMissMinType);
            break;
        case 2:
        case 3:
        case 4:
            break;
        case 5:
            fprintf(stderr, EOLCHR"Adjusting routing...");
            FixWildcard();
            RemoveUnnecessary();
            break;
      }
    return true;
  }

local boolean
LoadConfig(void)
  {
    FILE * cfg;
    boolean   KeyWordFailed;

    if ((cfg = fopen(CfgFile, "rt")) != 0)
      {
        char tmp[50];
        fprintf(stderr, ""EOLCHR"Scanning config file...");
	ushort i;
        for (i = 0; i < CFG_PASSES; i++ )
          {
            CfgLine = 0;
            KeyWordFailed = false;

            while (fgets(Buff, BUFFLEN-1,cfg))
              {
                CfgLine++;
                char * p = Buff;
                skipws(&p);
                if (*p == ';' || *p == '\n' || *p == '\0')
                    continue; // skip blank line or comment
                char * p1 = tmp;
                while (!isspace(*p))
                    *(p1++) = *(p++);
                *p1 = 0;

		int j;
                for (j = 0; j < ItemNum(CfgTab); j++)
                  {
                    if (CfgTab[j].Pass == i &&
                         stricmp(CfgTab[j].Name, tmp) == 0)
                      {
                        skipws(&p);
                        KeyWordFailed |= !CfgTab[j].LoadVal(p, CfgTab[j].Value);
                      }
                  }
              }
            if (KeyWordFailed || !PassOK(i))
                return false;
            rewind(cfg);
          }
        return true;
      }
    else
        Error(ErrOpenCfg);
    return false;
  }

int
main(int argc, char * argv[])
  {
    fprintf(stderr, "Hubroute generator v."VERSION"("TARGET") "DATE""EOLCHR""
                    "Copyright (c)1994-2003 by Yuri Safronov@2:5020/204"EOLCHR"");

    if (argc > 1)
      {
        if (strcmp(argv[1], "?") == 0 || stricmp(argv[1], "-?") == 0
                                     || stricmp(argv[1], "/?") == 0)
          {
            fprintf(stderr,""EOLCHR"Usage: Route [config]"EOLCHR"");
            return 0;
          }
      }

    PrevNode.CleanUp();

  // Allocate buffers
#ifndef _OS2
//    fprintf(stderr, "Available memory: %ld"EOLCHR"", coreleft());
#endif
    Buff = (char*)malloc(BUFFLEN);
    Prefix = (char*)malloc(500);
    Node = (listitem*)calloc(MAXNODES, sizeof (listitem));
    Link = (link *)calloc(MAXLINKS, sizeof (link));
    CfgFile = (char*)calloc(1, PATHLEN);
    MyNode = (nodeaddr*)calloc(MAXAKAS, sizeof (nodeaddr));

    if (Buff == NULL || Prefix == NULL || Node == NULL || Link == NULL
                  || CfgFile == NULL || MyNode == NULL)
      {
        Error(ErrNoMemory);
        return 2;
      }
    else
      {
#ifndef _OS2
//        fprintf(stderr, "Free memory: %ld"EOLCHR"", coreleft());
#endif
        nNodes = 0;
        nLinks = 0;

        if (argc == 1)
            strcpy(CfgFile, "mkroute.cfg");
        else
            strcpy(CfgFile, argv[1]);

        if (LoadConfig())
          {
            fprintf(stderr, ""EOLCHR"Writing routing...");
            time(&currtime);
            switch (RouteMode)
              {
                case SQUISH:
                    PutRoutingSq(); break;
                case ITRACK:
                    PutRoutingItr(); break;
                case TMAIL:
                    PutRoutingTmail(); break;
                case BPACK:
                    PutRoutingBpack(); break;
                case IMBINK:
                    PutRoutingImb(); break;
                case XMAIL:
                    PutRoutingXmail(); break;
                case IFMAIL:
                    PutRoutingIfmail(); break;
                case BIP:
                    PutRoutingBip(); break;
                case UNIMAIL:
                    PutRoutingUnimail(); break;
                case QECHO:
                    PutRoutingQecho(); break;
                case FIDOGATE:
                    PutRoutingFidogate(); break;
                case FTRACK:
                    PutRoutingFtrack(); break;
              }
            PutUnRouted();
            Spit(RouteEnd);
            while (fgets(Buff, BUFFLEN-1, OldRoute))
                 fputs(Buff, NewRoute);
            fclose(OldRoute);
            fclose(NewRoute);
            unlink(WriteTo);
            rename(TempFile, WriteTo);
            fprintf(stderr, ""EOLCHR"Done! Total of %d links and %d items.",
                                                 nLinks, nNodes);
            return 0;
          }
        else
            return 1;
      }
  }
